Scriptname _SLSubmitQuest extends Quest  

import game
import debug

float Property SkillUseBribe Auto  Conditional
{skill uses for flatter (magnitude for AdvanceSkill)}
float Property SkillUseMultiplier Auto Conditional
{Base multiplier for skill uses. Formula is based off the skill use multiplier set in Speechcraftt}
MiscObject Property Gold Auto
int Property BribeAmount Auto

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitScene Property _SLScene Auto
_SLSubmitFunctions Property _SLFunctions Auto
SexLabFramework Property SexLab  Auto  
sslSystemConfig Property SexLabConfig  Auto
SPELL Property _SLSubmitAutoSurrender  Auto  
MagicEffect Property _SLAutoSurrender  Auto
Spell Property Slap Auto
MagicEffect Property SlapEffect Auto

Actor Property playerRef Auto
Keyword Property Vampire Auto
Keyword Property ActorTypeNPC Auto
_SLSubmitTargetSelect property TargetSelect auto
GlobalVariable Property _SLSubmitBribeGlobal  Auto   
GlobalVariable Property _SLSubmitEscapeBonus  Auto   
GlobalVariable Property _SLSubmitFailurePenalty  Auto   
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitSpeechBonus  Auto
GlobalVariable Property _SLSubmitHotkeyGlobal Auto
GlobalVariable Property _SLSubmitGenderMaleGlobal Auto
GlobalVariable Property _SLSubmitGenderFemaleGlobal Auto
Float Property SpeechModifier  Auto 
SPELL Property _SLSubmitEscape  Auto
SPELL Property _SLSubmitShout  Auto
SPELL Property _SLSubmitSmack  Auto
SPELL Property _SLSubmitVLShout  Auto
SPELL Property _SLSubmitWShout  Auto
SPELL Property _SLSubmitAmbush  Auto
SPELL Property _SLSubmitVShout  Auto
SPELL Property _SLSubmitAssign  Auto  
SPELL Property _SLSubmitSurrender  Auto  
Faction Property _SLSubmitLoverFaction  Auto  
Faction Property Companion Auto
Faction Property BanditF Auto
Faction Property BanditAllyF Auto
Faction Property NecromancerF Auto
Faction Property ForswornF Auto
Faction Property WarlockF Auto
Faction Property WarlockAllyF Auto
Faction Property VampireF Auto
Faction Property VampireThrallF Auto
Faction Property _SLSubmitRejectedFaction Auto
Race Property Werewolf Auto
Race property BearBlack auto
Race property BearBrown auto
Race property BearSnow auto
Race property SabreCat auto
Race property SabreCatSnowy auto
Race property Chaurus auto
Race property ChaurusReaper auto
Race property Dragon auto
Race property UndeadDragon auto
Race property Draugr auto
Race property DraugrMagic auto
Race property Falmer auto
Race property Giant auto
Race property Horse auto
Race property FrostbiteSpider auto
Race property FrostbiteSpiderGiant auto
Race property FrostbiteSpiderLarge auto
Race property Troll auto
Race Property FrostTroll auto
Race property Wolf auto
Race property Dog auto
Race property DogCompanion auto
Race property MG07Dog auto
Race property DA03BarbasDog auto
GlobalVariable Property AbuseChanceGlobal  Auto 
GlobalVariable Property AbuseRollGlobal  Auto  
GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
GlobalVariable Property BoundGlobal  Auto
GlobalVariable Property BribeChance  Auto  
GlobalVariable Property BribeRoll  Auto  
GlobalVariable Property CoerceChance  Auto  
GlobalVariable Property CoerceRoll  Auto  
GlobalVariable Property SeduceChance  Auto  
GlobalVariable Property SeduceRoll  Auto  
GlobalVariable Property SpeechSkillMult  Auto  
GlobalVariable Property AttemptCost Auto
Armor Property _SLSubmitCuffs Auto
float Property PHealth  Auto
float Property PSpeech  Auto
float Property POnehanded  Auto
float Property PTwohanded  Auto
float Property PMarksman  Auto
float Property PDestruction  Auto
float Property PIllusion  Auto
float Property PPrime Auto
float Property THealth  Auto
float Property TSpeech  Auto
float Property TOnehanded  Auto
float Property TTwohanded  Auto
float Property TMarksman  Auto
float Property TDestruction  Auto
float Property TIllusion  Auto
float Property TPrime Auto
Quest Property Alduin Auto
Quest Property Harbingers Auto
Quest Property College Auto
Quest Property Thieves Auto
Quest Property Brotherhood Auto
Perk Property LPNovice Auto
Perk Property LPApprentice Auto
Perk Property LPAdept Auto
Perk Property LPExpert Auto
Perk Property LPMaster Auto
Perk Property Allure Auto
Perk Property HypnoticGaze Auto
Perk Property AspectOfTerror Auto
Perk Property Persuasion Auto
Perk Property Bribery Auto
Perk Property Intimidation Auto
Perk Property Dibella Auto
Perk Property Mara Auto
AssociationType Property Spouse  Auto  
AssociationType Property Courting  Auto  

FavorJarlsMakeFriendsScript Property FavorJarlsMakeFriends Auto
Faction Property WinterholdTown  Auto
Faction Property FalkreathTown  Auto
Faction Property SolitudeTown  Auto
Faction Property MorthalTown  Auto
Faction Property DawnstarTown  Auto
Faction Property MarkathTown  Auto
Faction Property WhiterunTown  Auto
Faction Property RiftenTown  Auto
Faction Property CrimeEastmarch  Auto
Faction Property CrimeFalkreath  Auto
Faction Property CrimeHaafingar  Auto
Faction Property CrimeHjaalmarch  Auto
Faction Property CrimePale  Auto
Faction Property CrimeReach  Auto
Faction Property CrimeWhiterun  Auto
Faction Property CrimeWinterhold  Auto
Faction Property CrimeRift  Auto
Faction Property WindhelmTown  Auto
Faction Property SolitudePalace  Auto
Faction Property WindhelmPalace  Auto

Bool Property Dawnguard Auto
Race DLC1HuskyArmoredCompanion
Race DLC1DeathHoundCompanion
Race DLC1DeathHound
Race SkeletonArmor
Race DLC1SoulCairnKeeper
Race DLC1SoulCairnSkeletonArmor
Race DLC1VampireBeast
Race DLC1Gargoyle
Race DLC1GargoyleVariantBoss
Race DLC1GargoyleVariantGreen

Bool Property Dragonborn Auto
Race DLC2Seeker
Race DLC2AshSpawn

Bool Property PrisonOverhaul Auto
Bool Property DeathAlternative Auto
_slsubmitpowrapper Property xpoMain Auto

Bool Property CapturedDreams Auto

Bool Property Brawling=False Auto

int submitKeyCode = 71			;NP7

Function InitializeMod()
	_SLFunctions.Log("InitializeMod()")
	Debug.Notification("Initializing SexLab Submit...")
	setupMod()
	Debug.Notification("SexLab Submit has been initialized.")
EndFunction

Function DLCLoad()
	_SLFunctions.Log("DLCLoad()")
	int Mods = Game.GetModCount()
	int i = 0
	While i < Mods
		string Modname = Game.GetModName(i)
		If !Dawnguard && Modname == "Dawnguard.esm"
			Dawnguard = true
			; Dogs
			DLC1HuskyArmoredCompanion = Game.GetFormFromFile(0x3D01, "Dawnguard.esm") as Race
			DLC1DeathHoundCompanion = Game.GetFormFromFile(0x3D02, "Dawnguard.esm") as Race
			DLC1DeathHound = Game.GetFormFromFile(0xC5F0, "Dawnguard.esm") as Race
			; Draugr
			SkeletonArmor = Game.GetFormFromFile(0x23E2, "Dawnguard.esm") as Race
			DLC1SoulCairnKeeper = Game.GetFormFromFile(0x7AF3, "Dawnguard.esm") as Race
			DLC1SoulCairnSkeletonArmor = Game.GetFormFromFile(0x894D, "Dawnguard.esm") as Race
			; Vampire Lord
			DLC1VampireBeast = Game.GetFormFromFile(0x283A, "Dawnguard.esm") as Race
			; Gargoyle
			DLC1Gargoyle = Game.GetFormFromFile(0xA2C6, "Dawnguard.esm") as Race
			DLC1GargoyleVariantBoss = Game.GetFormFromFile(0x10D00, "Dawnguard.esm") as Race
			DLC1GargoyleVariantGreen = Game.GetFormFromFile(0x19D86, "Dawnguard.esm") as Race
		ElseIf !Dragonborn && Modname == "Dragonborn.esm"
			Dragonborn = true
			; Seeker
			DLC2Seeker = Game.GetFormFromFile(0x1DCB9, "Dragonborn.esm") as Race
			; Draugr
			DLC2AshSpawn  = Game.GetFormFromFile(0x1B637, "Dragonborn.esm") as Race
		ElseIf Dawnguard && Dragonborn
			return
		EndIf
		i += 1
	EndWhile
EndFunction

Faction slaArousedFaction = None
Function ReferenceLoad()
	bool prison = False
	bool daymoyl = False
	int mod = Game.GetModByName("xazPrisonOverhaul.esp")
	If mod != 255
		prison = True
		If !PrisonOverhaul
			PrisonOverhaul = True
			xpoMain.InitializeScript()
		EndIf
	EndIf	
	mod = Game.GetModByName("SexLabAroused.esm")	
	If mod != 255
		slaArousedFaction = Game.GetFormFromFile(0x3FC36, "SexLabAroused.esm") As Faction
	EndIf		
	mod = Game.GetModByName("daymoyl.esm")
	If mod != 255
		daymoyl = True
		If !DeathAlternative
			DeathAlternative = True
			_SLConfig.HardcoreActive = False
		EndIf
	EndIf
	; Mod has been removed disable support for it
	If !prison && PrisonOverhaul
		PrisonOverhaul = false
	EndIf
	If !daymoyl && DeathAlternative
		DeathAlternative = false
	EndIf
EndFunction

Function setSubmitKeyCode(int newKeyCode)
	UnregisterForKey(submitKeyCode)
	submitKeyCode = newKeyCode
	RegisterForKey(submitKeyCode)
EndFunction

Function deactivateMod()
	If _SLConfig.modActive
		unsetMod()
	EndIf
EndFunction

Function activateMod()
	If _SLConfig.modActive
		setupMod()
	EndIf
EndFunction

Function manActivateMod()
	setupMod()
EndFunction

Function manDeactivateMod()
	unsetMod()
EndFunction

Function setupMod()
	DLCLoad()
	ReferenceLoad()
	RegisterForKey(submitKeyCode)
	If (PlayerRef.HasMagicEffect(SlapEffect))
		If(_SLConfig.debugActive)
			debug.Notification("Erroneous Unarmed Damage Reduction Removed!")
		EndIf
		PlayerRef.DispelSpell(Slap)
	EndIf
	_SLScene.WRT(2.0)	
	If (_SLConfig.SurrenderActive && _SLConfig.AutoSurrenderActive)
		If (!PlayerRef.HasMagicEffect(_SLAutoSurrender))
			PlayerRef.AddSpell(_SLSubmitAutoSurrender,false)
		EndIf
	Else
		If (PlayerRef.HasMagicEffect(_SLAutoSurrender))
			PlayerRef.RemoveSpell(_SLSubmitAutoSurrender)
		EndIf
	EndIf
	If (_SLConfig.Gender == 0)
		If (PlayerRef.GetActorBase().GetSex() == 0)
			_SLSubmitGenderMaleGlobal.SetValue(0)
			_SLSubmitGenderFemaleGlobal.SetValue(1)
		Else
			_SLSubmitGenderMaleGlobal.SetValue(1)
			_SLSubmitGenderFemaleGlobal.SetValue(0)
		EndIf
	ElseIf (_SLConfig.Gender == 1)
		If (PlayerRef.GetActorBase().GetSex() == 0)
			_SLSubmitGenderMaleGlobal.SetValue(1)
			_SLSubmitGenderFemaleGlobal.SetValue(0)
		Else
			_SLSubmitGenderMaleGlobal.SetValue(0)
			_SLSubmitGenderFemaleGlobal.SetValue(1)
		EndIf
	Else
		_SLSubmitGenderMaleGlobal.SetValue(1)
		_SLSubmitGenderFemaleGlobal.SetValue(1)
	EndIf
EndFunction

Function unsetMod()
	UnregisterForKey(submitKeyCode)
	If (PlayerRef.HasMagicEffect(SlapEffect))
		If(_SLConfig.debugActive)
			debug.Notification("Erroneous Unarmed Damage Reduction Removed!")
		EndIf
		PlayerRef.DispelSpell(Slap)
	EndIf
EndFunction

Event OnKeyDown(int keyCode)
	If (_SLSubmitHotkeyGlobal.GetValue() == 0)
		_SLSubmitHotkeyGlobal.SetValue(1)
		sslThreadController Thread = SexLab.GetPlayerController()
		AttemptCost.SetValue(PlayerRef.GetBaseAV("Stamina") * 0.2)
		If (AttemptCost.GetValue() > 50)
			AttemptCost.SetValue(50)
		EndIf
		If(keyCode == submitKeyCode && !UI.IsMenuOpen("Main Menu") && !UI.IsMenuOpen("Console") && !UI.IsMenuOpen("StatsMenu") && !UI.IsMenuOpen("MagicMenu") && !UI.IsMenuOpen("InventoryMenu") && !UI.IsMenuOpen("MapMenu") && !UI.IsMenuOpen("Journal Menu") && !UI.IsMenuOpen("Lockpicking Menu") && !UI.IsMenuOpen("ContainerMenu") && !UI.IsMenuOpen("RaceSex Menu"))
			If (PlayerRef.GetRace() != Werewolf && PlayerRef.GetRace() != DLC1VampireBeast)
				If (_SLConfig.AttackActive && PlayerRef.IsSneaking() && PlayerRef.GetAV("Stamina") >= AttemptCost.GetValue() && !PlayerRef.IsEquipped(_SLSubmitCuffs))
					_SLSubmitAmbush.Cast(playerRef)
				ElseIf (_SLConfig.AttackActive && !PlayerRef.IsSneaking() && PlayerRef.GetAV("Stamina") >= AttemptCost.GetValue() && PlayerRef.IsWeaponDrawn() && _SLConfig.GrappleActive)
					_SLSubmitSmack.Cast(playerRef)
				ElseIf (_SLConfig.AttackActive && !PlayerRef.IsSneaking() && PlayerRef.GetVoiceRecoveryTime() <= 0 && PlayerRef.IsWeaponDrawn() && !_SLConfig.GrappleActive)
					Debug.SendAnimationEvent(playerRef, "JumpLand")
					If (PlayerRef.HasKeyword(Vampire))
						_SLSubmitVShout.Cast(playerRef)
					Else
						_SLSubmitShout.Cast(playerRef)
					EndIf
					PlayerRef.SetVoiceRecoveryTime(_SLConfig.ShoutCooldown)
				ElseIf (!PlayerRef.IsSneaking() && _SLConfig.SurrenderActive && (!_SLConfig.AttackActive || !PlayerRef.IsWeaponDrawn()))
					If (BoundGlobal.GetValue() >= 1)
						If ((PlayerRef.GetAV("Stamina") >= AttemptCost.GetValue()) && (BoundGlobal.GetValue() == 2))
							_SLSubmitEscape.Cast(playerRef)
						EndIf	
						_SLScene.WRT(2.0)		
					Else	
						If (PlayerRef.IsInCombat())
							If (!_SLConfig.AttackActive && PlayerRef.IsWeaponDrawn())
								PlayerRef.SheatheWeapon()	
							EndIf
							_SLFunctions.ClearAssailants()
							_SLSubmitSurrenderGlobal.SetValue(1)
							_SLSubmitAssign.Cast(playerRef)
							_SLFunctions.Surrender()
						ElseIf (!_SLConfig.AttackActive && !PlayerRef.IsEquipped(_SLSubmitCuffs))
							If (Thread == None || Thread.GetState() != "Animating")
								PlayerRef.DrawWeapon()
							EndIf
						EndIf
					EndIf
				EndIf
			Else
				Debug.SendAnimationEvent(playerRef, "JumpLand")
				If (PlayerRef.GetRace() == Werewolf)
					_SLSubmitWShout.Cast(playerRef)
				Else
					_SLSubmitVLShout.Cast(playerRef)
				EndIf
			EndIf
		EndIf
		If (Thread != None && Thread.GetState() == "Animating")
			Thread.EndAnimation(True)
		EndIf
		_SLScene.WRT(0.5)
		_SLSubmitHotkeyGlobal.SetValue(0)
	EndIf
EndEvent

Function GatherStats(Actor Target, Actor Player)
	PHealth = PlayerRef.GetAV("Health")/PlayerRef.GetBaseAV("Health")*100
	PSpeech = PlayerRef.GetAV("Speechcraft")
	PIllusion = PlayerRef.GetAV("Illusion")
	POnehanded = PlayerRef.GetAV("OneHanded")
	PTwohanded = PlayerRef.GetAV("TwoHanded")
	PMarksman = PlayerRef.GetAV("Marksman")
	PDestruction = PlayerRef.GetAV("Destruction")
	If (POneHanded >= PTwoHanded && POneHanded >= PMarksman && POneHanded >= PDestruction)
		PPrime = POneHanded
	ElseIf (PTwoHanded >= POneHanded && PTwoHanded >= PMarksman && PTwoHanded >= PDestruction)
		PPrime = PTwoHanded
	ElseIf (PMarksman >= POneHanded && PMarksman >= PTwoHanded && PMarksman >= PDestruction)
		PPrime = PMarksman
	Else
	PPrime = PDestruction
	EndIf

	THealth = Target.GetAV("Health")/Target.GetBaseAV("Health")*100
	TSpeech = Target.GetAV("Speechcraft")
	TIllusion = Target.GetAV("Illusion")
	TOnehanded = Target.GetAV("OneHanded")
	TTwohanded = Target.GetAV("TwoHanded")
	TMarksman = Target.GetAV("Marksman")
	TDestruction = Target.GetAV("Destruction")
	If (TOneHanded >= TTwoHanded && TOneHanded >= TMarksman && TOneHanded >= TDestruction)
		TPrime = TOneHanded
	ElseIf (TTwoHanded >= TOneHanded && TTwoHanded >= TMarksman && TTwoHanded >= TDestruction)
		TPrime = TTwoHanded
	ElseIf (TMarksman >= TOneHanded && TMarksman >= TTwoHanded && TMarksman >= TDestruction)
		TPrime = TMarksman
	Else
		TPrime = TDestruction
	EndIf
EndFunction

Function ShoutChance()
	SuccessChance.SetValue(((100 - THealth) * PHealth / 100) + ((PSpeech - TSpeech)/4) + (PPrime - TPrime) + _SLConfig.CDifficulty - _SLSubmitFailurePenalty.GetValue())
	If (SuccessChance.GetValue() > 90)
		SuccessChance.SetValue(90)
	ElseIf (SuccessChance.GetValue() < 10)
		If (_SLConfig.CDifficulty >= 0)
			SuccessChance.SetValue(10 + _SLConfig.CDifficulty)
		Else
			SuccessChance.SetValue(10)
		EndIf
	EndIf
	SuccessRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function AmbushChance()
	SuccessChance.SetValue(((100 - THealth) * PHealth / 100) + ((PSpeech - TSpeech)/4) + (PPrime - TPrime) + _SLConfig.CDifficulty + 25)
	If (SuccessChance.GetValue() > 90)
		SuccessChance.SetValue(90)
	ElseIf (SuccessChance.GetValue() < 10)
		If (_SLConfig.CDifficulty >= 0)
			SuccessChance.SetValue(10 + _SLConfig.CDifficulty)
		Else
			SuccessChance.SetValue(10)
		EndIf
	EndIf
	SuccessRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function AmbushSleepChance()
	SuccessChance.SetValue(((100 - THealth) * PHealth / 100) + ((PSpeech - TSpeech)/4) + (PPrime - TPrime) + _SLConfig.CDifficulty + 50)
	If (SuccessChance.GetValue() > 90)
		SuccessChance.SetValue(90)
	ElseIf (SuccessChance.GetValue() < 10)
		If (_SLConfig.CDifficulty >= 0)
			SuccessChance.SetValue(10 + _SLConfig.CDifficulty)
		Else
			SuccessChance.SetValue(10)
		EndIf
	EndIf
	SuccessRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function EscapeChance()
	If ((PlayerRef.HasPerk(LPNovice) && _SLConfig.Escape == 1.0) || (PlayerRef.HasPerk(LPApprentice) && _SLConfig.Escape == 2.0) || (PlayerRef.HasPerk(LPAdept) && _SLConfig.Escape == 3.0) || (PlayerRef.HasPerk(LPExpert) && _SLConfig.Escape == 4.0) || (PlayerRef.HasPerk(LPMaster) && _SLConfig.Escape == 5.0))
		SuccessChance.SetValue(PlayerRef.GetAV("Lockpicking") - ((_SLConfig.Escape - 1) * 7.5) + _SLConfig.CDifficulty + _SLSubmitEscapeBonus.GetValue())
	Else
		SuccessChance.SetValue(PlayerRef.GetAV("Lockpicking") - ((_SLConfig.Escape - 1) * 15.0) + _SLConfig.CDifficulty + _SLSubmitEscapeBonus.GetValue())
	EndIf
	If (SuccessChance.GetValue() > 90)
		SuccessChance.SetValue(90)
	ElseIf (SuccessChance.GetValue() < 10)
		If (_SLConfig.CDifficulty >= 0)
			SuccessChance.SetValue(10 + _SLConfig.CDifficulty + _SLSubmitEscapeBonus.GetValue())
		Else
			SuccessChance.SetValue(10 + _SLSubmitEscapeBonus.GetValue())
		EndIf
	EndIf
	SuccessRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function SpeechModifier(Actor Target)
	_SLSubmitSpeechBonus.SetValue(Target.GetRelationshipRank(PlayerRef) * 10)
	If (Alduin.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf		
	If (Harbingers.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (Thieves.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (College.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (Brotherhood.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (PlayerRef.HasPerk(Allure))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (PlayerRef.HasPerk(Dibella))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (PlayerRef.HasPerk(Mara))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (Target.IsInFaction(_SLSubmitRejectedFaction))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() - 15)
	EndIf
	If (Target.IsGuard() && !Target.IsInFaction(Companion))
		If(_SLConfig.debugActive)
			debug.Notification("Target is an on duty Guard and will be very difficult!")
		EndIf
	EndIf	
	If (Target.HasAssociation(Spouse) && !Target.HasAssociation(Spouse, PlayerRef))
		If(_SLConfig.debugActive)
			debug.Notification("Target is already married and will be extremely difficult!")
		EndIf
	EndIf	
	If (Target.HasAssociation(Courting) && !Target.HasAssociation(Spouse, PlayerRef))
		If(_SLConfig.debugActive)
			debug.Notification("Target is already courting and will be difficult!")
		EndIf
	EndIf	
	If ((Target.GetLeveledActorBase().GetSex() == PlayerRef.GetActorBase().GetSex()) && (Target.GetRelationshipRank(PlayerRef) < 4) && (!Target.IsInFaction(_SLSubmitLoverFaction)))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() - 10)
	EndIf	
	If ((Target.GetLeveledActorBase().GetRace() != PlayerRef.GetActorBase().GetRace()) && (Target.GetRelationshipRank(PlayerRef) < 4) && (!Target.IsInFaction(_SLSubmitLoverFaction)))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() - 5)
	EndIf	
	If (FavorJarlsMakeFriends.WhiterunImpGetOutofJail > 0 || FavorJarlsMakeFriends.WhiterunSonsGetOutofJail > 0)
		If (Target.IsInFaction(WhiterunTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeWhiterun))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.EastmarchImpGetOutofJail > 0 || FavorJarlsMakeFriends.EastmarchSonsGetOutofJail > 0)
		If (Target.IsInFaction(WindhelmTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeEastmarch) || Target.IsInFaction(WindhelmPalace))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.FalkreathImpGetOutofJail > 0 || FavorJarlsMakeFriends.FalkreathSonsGetOutofJail > 0)
		If (Target.IsInFaction(FalkreathTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeFalkreath))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.HaafingarImpGetOutofJail > 0 || FavorJarlsMakeFriends.HaafingarSonsGetOutofJail > 0)
		If (Target.IsInFaction(SolitudeTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeHaafingar) || Target.IsInFaction(SolitudePalace))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.HjaalmarchImpGetOutofJail > 0 || FavorJarlsMakeFriends.HjaalmarchSonsGetOutofJail > 0)
		If (Target.IsInFaction(MorthalTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeHjaalmarch))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.PaleImpGetOutofJail > 0 || FavorJarlsMakeFriends.PaleSonsGetOutofJail > 0)
		If (Target.IsInFaction(DawnstarTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimePale))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.ReachImpGetOutofJail > 0 || FavorJarlsMakeFriends.ReachSonsGetOutofJail > 0)
		If (Target.IsInFaction(MarkathTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeReach))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.WinterholdImpGetOutofJail > 0 || FavorJarlsMakeFriends.WinterholdSonsGetOutofJail > 0)
		If (Target.IsInFaction(WinterholdTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeWinterhold))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.RiftImpGetOutofJail > 0 || FavorJarlsMakeFriends.RiftSonsGetOutofJail > 0)
		If (Target.IsInFaction(RiftenTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeRift))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (slaArousedFaction != None)
		Float arousalBonus = (Target.GetFactionRank(slaArousedFaction) as Float) / 100.0
		arousalBonus = arousalBonus * arousalBonus * 20
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + arousalBonus)
;		Debug.Notification("Arousal effect " + arousalBonus)
	EndIf
EndFunction

Function SeduceChance(Actor Target)
	SpeechModifier(Target)
	If (PlayerRef.HasPerk(HypnoticGaze))
		SpeechModifier = _SLSubmitSpeechBonus.GetValue() + 5
		_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	EndIf	
	If (PlayerRef.HasPerk(Persuasion))
		SpeechModifier = _SLSubmitSpeechBonus.GetValue() + 5
		_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	EndIf	
	SeduceChance.SetValue(((PSpeech - TSpeech/4)) + ((PIllusion - TIllusion/4)/2) + _SLConfig.SDifficulty + _SLSubmitSpeechBonus.GetValue())
	If (SeduceChance.GetValue() > 90)
		SeduceChance.SetValue(90)
	ElseIf (SeduceChance.GetValue() < 10)
		If (_SLConfig.SDifficulty >= 0)
			SeduceChance.SetValue(10 + _SLConfig.SDifficulty)
		Else
			SeduceChance.SetValue(10)
		EndIf
	EndIf
	If (Target.HasAssociation(Spouse) && !Target.HasAssociation(Spouse, PlayerRef))
		If (Target.IsInFaction(_SLSubmitLoverFaction))
			SeduceChance.SetValue(SeduceChance.GetValue() - 20)
		Else
			SeduceChance.SetValue(SeduceChance.GetValue() - 40)
		EndIf
	ElseIf (Target.HasAssociation(Courting) && !Target.HasAssociation(Spouse, PlayerRef))
		If (Target.IsInFaction(_SLSubmitLoverFaction))
			SeduceChance.SetValue(SeduceChance.GetValue() - 10)
		Else
			SeduceChance.SetValue(SeduceChance.GetValue() - 20)
		EndIf
	EndIf
	If (Target.IsGuard() && !Target.IsInFaction(Companion))
		SeduceChance.SetValue(SeduceChance.GetValue() - 30)
	EndIf	
	If (Target.IsInFaction(_SLSubmitRejectedFaction))
		SeduceChance.SetValue(SeduceChance.GetValue() - 15)
	EndIf
	SeduceRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function BribeChance(Actor Target)
	SpeechModifier(Target)
	If (PlayerRef.HasPerk(HypnoticGaze))
		SpeechModifier = _SLSubmitSpeechBonus.GetValue() + 5
		_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	EndIf	
	If (PlayerRef.HasPerk(Bribery))
		SpeechModifier = _SLSubmitSpeechBonus.GetValue() + 5
		_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	EndIf	
	_SLSubmitBribeGlobal.SetValue(Target.GetBribeAmount() * _SLConfig.Bribery)
	SpeechModifier = _SLSubmitSpeechBonus.GetValue() + (_SLSubmitBribeGlobal.GetValue()/(10 * (1 + Target.GetAV("Morality"))))
	_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	BribeChance.SetValue(((PSpeech - TSpeech/4)) + ((PIllusion - TIllusion/4)/2) + _SLConfig.SDifficulty + _SLSubmitSpeechBonus.GetValue())
	If (BribeChance.GetValue() > 90)
		BribeChance.SetValue(90)
	ElseIf (BribeChance.GetValue() < 10)
		If (_SLConfig.SDifficulty >= 0)
			BribeChance.SetValue(10 + _SLConfig.SDifficulty)
		Else
			BribeChance.SetValue(10)
		EndIf
	EndIf
	If (Target.HasAssociation(Spouse) && !Target.HasAssociation(Spouse, PlayerRef))
		BribeChance.SetValue(BribeChance.GetValue() - 40)
	ElseIf (Target.HasAssociation(Courting) && !Target.HasAssociation(Spouse, PlayerRef))
		BribeChance.SetValue(BribeChance.GetValue() - 20)
	EndIf
	If (Target.IsGuard() && !Target.IsInFaction(Companion))
		BribeChance.SetValue(BribeChance.GetValue() - 30)
	EndIf	
	If (Target.IsInFaction(_SLSubmitRejectedFaction))
		BribeChance.SetValue(BribeChance.GetValue() - 15)
	EndIf
	BribeRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function Bribe(Actor pTarget)
	trace("Bribe: " + pTarget)
	SkillUseMultiplier = SpeechSkillMult.value
	SkillUseBribe = SkillUseMultiplier * PlayerRef.GetAv("Speechcraft")
	trace(self + "Current Skill uses given: " + SkillUseBribe + " times the Skill Use Multiplier")
	If _SLConfig.Bribery == 1.0
		BribeAmount = (pTarget.GetBribeAmount() * 1)
	ElseIf _SLConfig.Bribery == 2.0
		BribeAmount = (pTarget.GetBribeAmount() * 2)
	ElseIf _SLConfig.Bribery == 3.0
		BribeAmount = (pTarget.GetBribeAmount() * 3)
	ElseIf _SLConfig.Bribery == 4.0
		BribeAmount = (pTarget.GetBribeAmount() * 4)
	ElseIf _SLConfig.Bribery == 5.0
		BribeAmount = (pTarget.GetBribeAmount() * 5)
	ElseIf _SLConfig.Bribery == 6.0
		BribeAmount = (pTarget.GetBribeAmount() * 6)
	ElseIf _SLConfig.Bribery == 7.0
		BribeAmount = (pTarget.GetBribeAmount() * 7)
	ElseIf _SLConfig.Bribery == 8.0
		BribeAmount = (pTarget.GetBribeAmount() * 8)
	ElseIf _SLConfig.Bribery == 9.0
		BribeAmount = (pTarget.GetBribeAmount() * 9)
	ElseIf _SLConfig.Bribery == 10.0
		BribeAmount = (pTarget.GetBribeAmount() * 10)
	EndIf
	if BribeAmount <= GetPlayer().GetGoldAmount()
		GetPlayer().RemoveItem(Gold, BribeAmount)
		pTarget.AddItem(Gold, BribeAmount)
		pTarget.SetBribed()
		AdvanceSkill("Speechcraft", SkillUseBribe)
		Game.IncrementStat( "Bribes" )
		if ( Game.QueryStat( "Persuasions" ) && Game.QueryStat( "Intimidations" ) )
			Game.AddAchievement(28)
		endif
	endif
endFunction

Function CoerceChance(Actor Target)
	SpeechModifier(Target)
	If (PlayerRef.HasPerk(AspectOfTerror))
		SpeechModifier = _SLSubmitSpeechBonus.GetValue() + 5
		_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	EndIf	
	If (PlayerRef.HasPerk(Intimidation))
		SpeechModifier = _SLSubmitSpeechBonus.GetValue() + 5
		_SLSubmitSpeechBonus.SetValue(SpeechModifier)
	EndIf	
	CoerceChance.SetValue(((100 - THealth) * PHealth / 100) + ((PSpeech - TSpeech/4)/2) + ((PIllusion - TIllusion/4)/2) + (PPrime - TPrime) + ((Target.GetAV("Confidence") - 2.0) * 20.0) + _SLConfig.SDifficulty + _SLSubmitSpeechBonus.GetValue())
	If (CoerceChance.GetValue() > 90)
		CoerceChance.SetValue(90)
	ElseIf (CoerceChance.GetValue() < 10)
		If (_SLConfig.SDifficulty >= 0)
			CoerceChance.SetValue(10 + _SLConfig.SDifficulty)
		Else
			CoerceChance.SetValue(10)
		EndIf
	EndIf
	If (Target.IsGuard() && !Target.IsInFaction(Companion))
		CoerceChance.SetValue(CoerceChance.GetValue() - 30)
	EndIf	
	CoerceRoll.SetValue(Utility.RandomInt(0, 100))
EndFunction

Function AbuseChance(Actor Target)
	AbuseChanceGlobal.SetValue(25 - (Target.GetAV("Morality") * 5) + (_SLConfig.Morality * 10))
	If (Target.IsInInterior())
		AbuseChanceGlobal.SetValue(AbuseChanceGlobal.GetValue() + 25)
	EndIf
	If (slaArousedFaction != None)
		Float arousalBonus = (Target.GetFactionRank(slaArousedFaction) as Float) / 100.0
		arousalBonus = arousalBonus * arousalBonus * 20
		AbuseChanceGlobal.SetValue(AbuseChanceGlobal.GetValue() + arousalBonus)
	EndIf
	If (AbuseChanceGlobal.GetValue() > 90)
		AbuseChanceGlobal.SetValue(90)
	ElseIf (AbuseChanceGlobal.GetValue() < 10)
		AbuseChanceGlobal.SetValue(10)
	EndIf
	AbuseRollGlobal.SetValue(Utility.RandomInt(0, 100))
;	If(_SLConfig.debugActive)
;		Debug.Notification(AbuseChanceGlobal.GetValue() + "% success chance, " + AbuseRollGlobal.GetValue() + "% rolled.")
;	EndIf
EndFunction

bool Function IsHostileNPC(Actor Target)
	If (Target.HasKeyword(ActorTypeNPC) && !Target.IsGuard() && (Target.IsInFaction(BanditF) || Target.IsInFaction(BanditAllyF) || Target.IsInFaction(NecromancerF) || Target.IsInFaction(ForswornF) || Target.IsInFaction(WarlockF) || Target.IsInFaction(WarlockAllyF) || Target.IsInFaction(VampireF) || Target.IsInFaction(VampireThrallF) || (Target.GetBaseAV("Aggression") >= 1)))
		return True
	Else
		return False
	EndIf
EndFunction

bool Function SentientNPC(Actor Target)
	If (SexlabConfig.bAllowCreatures && Sexlab.AllowedCreature(Target.GetRace()) && (Target.GetRace() == Werewolf || Target.GetRace() == Draugr || Target.GetRace() == DraugrMagic || Target.GetRace() == Falmer || Target.GetRace() == Troll || Target.GetRace() == FrostTroll || Target.GetRace() == DLC1Gargoyle || Target.GetRace() == DLC1GargoyleVariantBoss || Target.GetRace() == DLC1GargoyleVariantGreen || Target.GetRace() == DLC1VampireBeast || Target.GetRace() == SkeletonArmor || Target.GetRace() == DLC1SoulCairnKeeper || Target.GetRace() == DLC1SoulCairnSkeletonArmor || Target.GetRace() == DLC2Seeker || Target.GetRace() == DLC2AshSpawn || Target.GetRace() == Giant))
		return True
	Else
		return False
	EndIf
EndFunction

bool Function NonSentientNPC(Actor Target)
	If (SexlabConfig.bAllowCreatures && Sexlab.AllowedCreature(Target.GetRace()) && (Target.GetRace() == BearBlack || Target.GetRace() == BearBrown || Target.GetRace() == BearSnow || Target.GetRace() == SabreCat || Target.GetRace() == SabreCatSnowy || Target.GetRace() == Chaurus || Target.GetRace() == ChaurusReaper || Target.GetRace() == Dragon || Target.GetRace() == UndeadDragon || Target.GetRace() == Horse || Target.GetRace() == FrostBiteSpider || Target.GetRace() == FrostBiteSpiderGiant || Target.GetRace() == FrostBiteSpiderLarge || Target.GetRace() == Wolf || Target.GetRace() == Dog || Target.GetRace() == DogCompanion || Target.GetRace() == MG07Dog || Target.GetRace() == DA03BarbasDog || Target.GetRace() == DLC1HuskyArmoredCompanion || Target.GetRace() == DLC1DeathHoundCompanion || Target.GetRace() == DLC1DeathHound))
		return True
	Else
		return False
	EndIf
EndFunction

bool Function IsValidTarget(actor Target)
	If ((_SLConfig.Creature >= 0 && Target.HasKeyword(ActorTypeNPC)) || (_SLConfig.Creature >= 1 && SentientNPC(Target)) || (_SLConfig.Creature >= 2 && NonSentientNPC(Target)))
		return True
	Else
		return False
	EndIf
EndFunction
